<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template name="createSummaryTable">
		<xsl:param name="title"/>
		<xsl:param name="nodeSet"/>
		<xsl:param name="packagePath"/>
		<xsl:param name="italikStyle"/>
		<table border="1" cellpadding="3" cellspacing="0" width="100%">
			<tr class="TableHeaderStyle">
				<td colspan="2">
					<font size="+2">
						<b>
							<xsl:value-of select="$title"/>
						</b>
					</font>
				</td>
			</tr>
			<xsl:for-each select="$nodeSet">
				<xsl:variable name="description">
					<xsl:apply-templates select="current()" mode="getDescription"/>
				</xsl:variable>
				<tr class="TableRow">
					<td width="15%">
						<b>
							<xsl:choose>
								<xsl:when test="not(local-name(current())='Package')">
									<xsl:apply-templates select="current()" mode="HRefWithImgLoad"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:apply-templates select="current()" mode="HRefWithImgLoad">
										<xsl:with-param name="isName" select="'1'"/>
									</xsl:apply-templates>
								</xsl:otherwise>
							</xsl:choose>
						</b>
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="string-length($description) &gt; 0">
								<xsl:copy-of select="Property[@name='description']"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>&#xA0;</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</td>
				</tr>
			</xsl:for-each>
		</table>
		<xsl:text>&#xA0;</xsl:text>
		<p/>
	</xsl:template>
	
	<xsl:template match="Model | Package | Classifier" mode="getFullPath">
		<xsl:choose>
			<xsl:when test="name()='Model'">
				<xsl:value-of select="$outdir"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="currPref">
					<xsl:call-template name="ResetPrefix">
						<xsl:with-param name="prefix" select="''"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="relPath">
					<xsl:apply-templates select="." mode="getRelativePath"/>
				</xsl:variable> 
				<xsl:variable name="fullPath" select="concat($outdir, '/', $relPath)"/>
				<xsl:variable name="tmpPrefix">
					<xsl:call-template name="ResetPrefix">
						<xsl:with-param name="prefix" select="$currPref"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="$fullPath"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- returns relative path from output dir to the -->
	<xsl:template match="Model | Package | Classifier" mode="getRelativePath">
		
		<xsl:choose>
			<xsl:when test="local-name()='Model'">
				<xsl:call-template name="GetCurrentPrefix"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="prefix">
					<xsl:call-template name="GetCurrentPrefix"/>
				</xsl:variable>
				<xsl:if test="not(local-name()='Classifier' and @isImported='true')">
					<!--xsl:variable name="parentsNodeSet" select="ancestor::Package | ancestor::Classifier"/-->
					<xsl:variable name="parentsNodeSet" select="ancestor::Package | ancestor::Classifier | ancestor::DesignElement"/>
					<xsl:variable name="parentPath">
						<xsl:for-each select="$parentsNodeSet">
							<xsl:value-of select="@name"/>
							<xsl:choose>
								<!--xsl:when test="name()='Classifier'">.</xsl:when-->
								<xsl:when test="not(local-name()='Package')">.</xsl:when>
								<xsl:otherwise>/</xsl:otherwise>
							</xsl:choose>
						</xsl:for-each>
					</xsl:variable>
					
					<xsl:variable name="resPath">
						<xsl:choose> 
							<xsl:when test="string-length($parentPath)=0"><xsl:value-of select="@name"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="concat($parentPath, @name)"/></xsl:otherwise>
						</xsl:choose>
					</xsl:variable> 
					<xsl:choose>
						<xsl:when test="string-length($prefix) &gt; 0">
							<xsl:value-of select="concat($prefix, $resPath)"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$resPath"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="Model | Package | Classifier" mode="getQualifiedName">
		<xsl:choose>
			<xsl:when test="local-name()='Model'">
				<!--xsl:value-of select="@name"></xsl:value-of-->
				<xsl:value-of select="''"></xsl:value-of>
			</xsl:when>
			<xsl:otherwise>
				<!--xsl:variable name="parentsNodeSet" select="ancestor::Package | ancestor::Classifier"/-->
				<xsl:variable name="parentsNodeSet" select="ancestor::Package | ancestor::Classifier | ancestor::DesignElement"/>
				<xsl:variable name="parentQualifiedName">
					<xsl:for-each select="$parentsNodeSet">
						<xsl:value-of select="@name"/>
						<xsl:if test="not(position()=last())">.</xsl:if>
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="resultName">
					<xsl:choose> 
						<xsl:when test="string-length($parentQualifiedName)=0"><xsl:value-of select="@name"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="concat($parentQualifiedName, '.', @name)"/></xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:value-of select="$resultName"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="classifierShortName">
		<xsl:param name="class"></xsl:param>
		
		<xsl:variable name="enclosingClass" select="$class/.."/>
		<xsl:choose>
			<xsl:when test="$enclosingClass and not((local-name($enclosingClass)='Package') or (local-name($enclosingClass)='Model'))">
				<xsl:variable name="parentShortName">
					<xsl:call-template name="classifierShortName">
						<xsl:with-param name="class" select="$enclosingClass"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="concat($parentShortName, '.', $class/@name)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$class/@name"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="ClassifierDefinitionString">
		<xsl:param name="class"></xsl:param>
    <xsl:call-template name="printVisibility">
      <xsl:with-param name="class" select="$class"/>
    </xsl:call-template>
    <xsl:if test="string($class/@type)='Delegate'">
      <xsl:variable name="typeName">
        <xsl:call-template name="typeRefHandler">
          <xsl:with-param name="parameter" select="$class/ReturnType"></xsl:with-param>
        </xsl:call-template>
      </xsl:variable>
      <xsl:choose>
        <xsl:when test="string-length(string($typeName)) &gt; 0">
          <xsl:choose>
            <xsl:when test="$prj_lang='delphi'">
              <xsl:text>function</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="$typeName"/>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:text> </xsl:text>
        </xsl:when>
        <xsl:when test="(current()/@isSubroutine) and ($prj_lang='vbnet')">
          <xsl:text>Sub</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:choose>
            <xsl:when test="$prj_lang='csharp'">
              <xsl:text>void</xsl:text>
            </xsl:when>
            <xsl:when test="$prj_lang='delphi'">
              <xsl:text>procedure</xsl:text>
            </xsl:when>
            <xsl:otherwise>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:text> </xsl:text>
    </xsl:if>
		<xsl:choose>
			<xsl:when test="string($class/@type)='Interface'">
				<xsl:call-template name="getLocalizedResource">
					<xsl:with-param name="code" select="'tinterface'"></xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="string($class/@type)='Struct'">
				<xsl:call-template name="getLocalizedResource">
					<xsl:with-param name="code" select="'tstruct'"></xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="string($class/@type)='Enum'">
				<xsl:call-template name="getLocalizedResource">
					<xsl:with-param name="code" select="'tenum'"></xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="string($class/@type)='Delegate'">
				<xsl:call-template name="getLocalizedResource">
					<xsl:with-param name="code" select="'tdelegate'"></xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="string($class/@type)='Module'">
				<xsl:call-template name="getLocalizedResource">
					<xsl:with-param name="code" select="'tmodule'"></xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="getLocalizedResource">
					<xsl:with-param name="code" select="'tclass'"></xsl:with-param>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="*" mode="getNamespace">
		<!--xsl:value-of select="Property[@name='Namespace']"/-->
		<xsl:variable name="parentPackages" select="ancestor::Package"/>
		<xsl:for-each select="$parentPackages">
			<xsl:value-of select="@name"/>
			<xsl:if test="not(position()=last())">
				<xsl:text>.</xsl:text>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>


	<!-- Prints single property -->
	<xsl:template name="printSingleProperty">
		<xsl:param name="propertyName"/>
		<xsl:param name="propertyValue"/>
		<dl>
			<dt/>
			<b><xsl:value-of select="$propertyName"/></b>
			<dd>
				<xsl:value-of select="$propertyValue"/>
			</dd>
		</dl>
	</xsl:template>
	
	<xsl:template name="getLocalizedClassType">
		<xsl:param name="type"/>
		
		<xsl:choose>
			<xsl:when test="$type='Interface'">
				<xsl:call-template name="getLocalizedResource">
					<xsl:with-param name="code" select="'Interface'"></xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$type='Struct'">
				<xsl:call-template name="getLocalizedResource">
					<xsl:with-param name="code" select="'Struct'"></xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$type='Enum'">
				<xsl:call-template name="getLocalizedResource">
					<xsl:with-param name="code" select="'Enum'"></xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$type='Delegate'">
				<xsl:call-template name="getLocalizedResource">
					<xsl:with-param name="code" select="'Delegate'"></xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$type='Module'">
				<xsl:call-template name="getLocalizedResource">
					<xsl:with-param name="code" select="'Module'"></xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="getLocalizedResource">
					<xsl:with-param name="code" select="'Class'"></xsl:with-param>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>
